<?php
session_start();
require_once __DIR__ . '/../../config/helpers.php';

$cfg = app_config();
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $pass = trim($_POST['password'] ?? '');
    $pdo = db();
    $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE email=? LIMIT 1");
    $stmt->execute([$email]);
    $admin = $stmt->fetch();
    if ($admin && password_verify($pass, $admin['password_hash'])) {
        $_SESSION['admin_id'] = (int)$admin['id'];
        header('Location: dashboard.php');
        exit;
    }
    $error = 'Invalid credentials';
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title><?php echo htmlspecialchars($cfg['APP_NAME']); ?> Admin Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="../assets/css/admin.css" rel="stylesheet">
</head>
<body class="d-flex align-items-center" style="min-height:100vh;">
<div class="container" style="max-width:420px;">
  <div class="card p-4">
    <div class="badge-soft d-inline-block mb-2">Admin Panel</div>
    <h4 class="fw-bold mb-3"><?php echo htmlspecialchars($cfg['APP_NAME']); ?></h4>

    <?php if ($error): ?>
      <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form method="post">
      <div class="mb-2">
        <label class="form-label">Email</label>
        <input name="email" type="email" class="form-control" required value="admin@utile.local">
      </div>
      <div class="mb-3">
        <label class="form-label">Password</label>
        <input name="password" type="password" class="form-control" required value="Admin@123">
      </div>
      <button class="btn btn-dark w-100" type="submit">Login</button>
      <div class="text-muted small mt-3">
        Demo: admin@utile.local / Admin@123
      </div>
    </form>
  </div>
</div>
</body>
</html>
