<?php
$active = 'dashboard';
require_once __DIR__ . '/partials/top.php';

$pdo = db();
$stats = [
  'vendors_total' => (int)$pdo->query("SELECT COUNT(*) c FROM vendors")->fetch()['c'],
  'vendors_pending' => (int)$pdo->query("SELECT COUNT(*) c FROM vendors WHERE approval_status='pending'")->fetch()['c'],
  'leads_available' => (int)$pdo->query("SELECT COUNT(*) c FROM leads WHERE is_available=1")->fetch()['c'],
  'jobs_ongoing' => (int)$pdo->query("SELECT COUNT(*) c FROM jobs WHERE status IN ('accepted','in_progress')")->fetch()['c'],
  'tx_total' => (int)$pdo->query("SELECT COUNT(*) c FROM wallet_transactions")->fetch()['c'],
];

$chart = $pdo->query("SELECT DATE(created_at) d, COUNT(*) c FROM wallet_transactions WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL 14 DAY) GROUP BY DATE(created_at) ORDER BY d")->fetchAll();
$labels = array_map(fn($r)=>$r['d'], $chart);
$values = array_map(fn($r)=>(int)$r['c'], $chart);
?>
<div class="row g-3">
  <div class="col-md-6 col-lg-3">
    <div class="card p-3">
      <div class="text-muted small">Total Vendors</div>
      <div class="fs-3 fw-bold"><?php echo $stats['vendors_total']; ?></div>
    </div>
  </div>
  <div class="col-md-6 col-lg-3">
    <div class="card p-3">
      <div class="text-muted small">Pending Approval</div>
      <div class="fs-3 fw-bold"><?php echo $stats['vendors_pending']; ?></div>
    </div>
  </div>
  <div class="col-md-6 col-lg-3">
    <div class="card p-3">
      <div class="text-muted small">Available Leads</div>
      <div class="fs-3 fw-bold"><?php echo $stats['leads_available']; ?></div>
    </div>
  </div>
  <div class="col-md-6 col-lg-3">
    <div class="card p-3">
      <div class="text-muted small">Ongoing Jobs</div>
      <div class="fs-3 fw-bold"><?php echo $stats['jobs_ongoing']; ?></div>
    </div>
  </div>
</div>

<div class="row g-3 mt-1">
  <div class="col-lg-8">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center">
        <div class="fw-semibold">Transactions Activity (14 days)</div>
        <div class="text-muted small">Total tx: <?php echo $stats['tx_total']; ?></div>
      </div>
      <canvas id="txChart" height="120"></canvas>
    </div>
  </div>
  <div class="col-lg-4">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Quick Links</div>
      <div class="d-grid gap-2">
        <a class="btn btn-dark" href="vendors.php">Manage Vendors</a>
        <a class="btn btn-outline-dark" href="leads.php">Manage Leads</a>
        <a class="btn btn-outline-dark" href="jobs.php">View Jobs</a>
        <a class="btn btn-outline-dark" href="transactions.php">View Transactions</a>
      </div>
    </div>
  </div>
</div>

<script>
const labels = <?php echo json_encode($labels); ?>;
const values = <?php echo json_encode($values); ?>;
new Chart(document.getElementById('txChart'), {
  type: 'line',
  data: { labels, datasets: [{ label: 'Transactions', data: values, tension: 0.3 }] },
  options: { responsive: true, plugins: { legend: { display: false } } }
});
</script>
<?php require_once __DIR__ . '/partials/bottom.php'; ?>
