-- Utile Vendor App (PHP + MySQL)
CREATE DATABASE IF NOT EXISTS utile_vendor_app CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE utile_vendor_app;

DROP TABLE IF EXISTS contact_messages;
DROP TABLE IF EXISTS wallet_transactions;
DROP TABLE IF EXISTS jobs;
DROP TABLE IF EXISTS leads;
DROP TABLE IF EXISTS vendor_tokens;
DROP TABLE IF EXISTS otp_codes;
DROP TABLE IF EXISTS vendor_kyc;
DROP TABLE IF EXISTS vendors;
DROP TABLE IF EXISTS admin_users;

CREATE TABLE admin_users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(80) NOT NULL,
  email VARCHAR(120) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

CREATE TABLE vendors (
  id INT AUTO_INCREMENT PRIMARY KEY,
  vendor_code VARCHAR(20) NOT NULL UNIQUE,
  name VARCHAR(120) NOT NULL,
  phone VARCHAR(20) NOT NULL UNIQUE,
  email VARCHAR(120) NULL,
  rating DECIMAL(3,2) DEFAULT 4.50,
  license_number VARCHAR(60) NULL,
  approval_status ENUM('pending','approved','rejected') DEFAULT 'pending',
  kyc_status ENUM('not_submitted','submitted','approved','rejected') DEFAULT 'not_submitted',
  is_active TINYINT(1) DEFAULT 0,
  wallet_balance INT DEFAULT 0,
  total_earnings INT DEFAULT 0,
  total_jobs INT DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB;

CREATE TABLE vendor_kyc (
  id INT AUTO_INCREMENT PRIMARY KEY,
  vendor_id INT NOT NULL,
  aadhar_front_path VARCHAR(255) NULL,
  aadhar_back_path VARCHAR(255) NULL,
  pan_front_path VARCHAR(255) NULL,
  pan_back_path VARCHAR(255) NULL,
  license_photo_path VARCHAR(255) NULL,
  license_number VARCHAR(60) NULL,
  status ENUM('not_submitted','submitted','approved','rejected') DEFAULT 'not_submitted',
  admin_notes TEXT NULL,
  submitted_at DATETIME NULL,
  reviewed_at DATETIME NULL,
  FOREIGN KEY (vendor_id) REFERENCES vendors(id) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE otp_codes (
  id INT AUTO_INCREMENT PRIMARY KEY,
  phone VARCHAR(20) NOT NULL,
  otp VARCHAR(10) NOT NULL,
  purpose ENUM('login','register') NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  expires_at DATETIME NOT NULL,
  INDEX(phone)
) ENGINE=InnoDB;

CREATE TABLE vendor_tokens (
  id INT AUTO_INCREMENT PRIMARY KEY,
  vendor_id INT NOT NULL,
  token VARCHAR(255) NOT NULL UNIQUE,
  expires_at DATETIME NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (vendor_id) REFERENCES vendors(id) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE leads (
  id INT AUTO_INCREMENT PRIMARY KEY,
  title VARCHAR(160) NOT NULL,
  customer_name VARCHAR(120) NOT NULL,
  customer_phone VARCHAR(20) NULL,
  service_details TEXT NULL,
  time_slot VARCHAR(120) NOT NULL,
  location VARCHAR(180) NOT NULL,
  lead_price INT NOT NULL,
  is_available TINYINT(1) DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

CREATE TABLE jobs (
  id INT AUTO_INCREMENT PRIMARY KEY,
  vendor_id INT NOT NULL,
  lead_id INT NOT NULL,
  status ENUM('accepted','in_progress','completed','cancelled') DEFAULT 'accepted',
  before_photo_path VARCHAR(255) NULL,
  after_photo_path VARCHAR(255) NULL,
  completion_otp_entered VARCHAR(10) NULL,
  earning_amount INT DEFAULT 500,
  started_at DATETIME NULL,
  completed_at DATETIME NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (vendor_id) REFERENCES vendors(id) ON DELETE CASCADE,
  FOREIGN KEY (lead_id) REFERENCES leads(id) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE wallet_transactions (
  id INT AUTO_INCREMENT PRIMARY KEY,
  vendor_id INT NOT NULL,
  type ENUM('credit','debit','earning') NOT NULL,
  amount INT NOT NULL,
  description VARCHAR(255) NULL,
  ref_type VARCHAR(30) NULL,
  ref_id INT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (vendor_id) REFERENCES vendors(id) ON DELETE CASCADE,
  INDEX(vendor_id)
) ENGINE=InnoDB;

CREATE TABLE contact_messages (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(120) NOT NULL,
  phone VARCHAR(20) NULL,
  message TEXT NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;
