# Utile Vendor App Backend (PHP + MySQL) — REST API + Admin Panel

This project provides a complete backend for the **Utile** Vendor App, matching the demo flows you described:
- OTP-based login/registration (demo OTP)
- Vendor KYC onboarding with document uploads
- Pending approval → admin approval → activated vendor
- Leads purchase using wallet balance → Ongoing Jobs
- Job lifecycle: accepted → in_progress (before photo) → completed (after photo + completion OTP)
- Wallet recharge (mocked) + full transaction history
- Dashboard summary (earnings/visits/recent jobs)
- **Admin panel** to manage vendors, approvals, KYC notes, leads, jobs, and transactions

Brand palette:
- Primary: `#FEF1E4`
- Secondary: `#212222`

---

## 1) Requirements

- XAMPP (Apache + MySQL)
- PHP 8.0+ recommended
- MySQL 5.7+ / 8+

---

## 2) Install on XAMPP

### Step A — Copy project to htdocs
1. Extract this project folder into:
   - `C:\xampp\htdocs\utile_vendor_app`
2. Your public site will be:
   - `http://localhost/utile_vendor_app/public`

### Step B — Create DB + Import schema/seed
1. Open phpMyAdmin:
   - `http://localhost/phpmyadmin`
2. Create a database named:
   - `utile_vendor_app`
3. Import:
   - `database/schema.sql`
   - then `database/seed.sql`

### Step C — Configure env
1. Copy `.env.example` → `.env`
2. Confirm settings (default XAMPP):
   - `DB_USER=root`
   - `DB_PASS=` (empty)
   - `DEMO_OTP=1234`
   - `COMPLETION_OTP=5678`
   - `UPLOAD_DIR=uploads`

---

## 3) URLs

### Landing Page
- `http://localhost/utile_vendor_app/public`

### REST API Base
- `http://localhost/utile_vendor_app/public/api`

### Admin Panel
- `http://localhost/utile_vendor_app/public/admin/login.php`

Admin demo credentials:
- Email: `admin@utile.local`
- Password: `Admin@123`

---

## 4) Vendor Demo Credentials (as per your app flow)

### Pre-approved vendor login
- Mobile: `9999999999`
- OTP: `1234`

This vendor is already approved and active (VEN001).

### New vendor registration
- Register with any `name/phone/email`
- OTP: `1234`
- Submit KYC documents (multipart upload)
- After KYC: vendor status is `submitted` and approval is pending
- Admin can approve from Admin Panel (and add KYC approval notes)

---

## 5) REST API Endpoints

### Auth
- `POST /auth/request-otp`
  ```json
  { "phone":"9999999999", "purpose":"login" }
  ```

- `POST /auth/register`
  ```json
  { "name":"Test", "phone":"9001112223", "email":"test@x.com", "otp":"1234" }
  ```

- `POST /auth/login`
  ```json
  { "phone":"9999999999", "otp":"1234" }
  ```
Returns `{ token }` to use as `Authorization: Bearer <token>`.

### Vendor
- `GET /vendor/me`
- `POST /vendor/kyc` (multipart fields):
  - `aadhar_front`, `aadhar_back`, `pan_front`, `pan_back`, `license_photo`, `license_number`
- `POST /vendor/simulate-approval` (demo activation)

### Leads
- `GET /leads`
- `GET /leads/{id}`
- `POST /leads/{id}/pick`

### Jobs
- `GET /jobs/ongoing`
- `GET /jobs/completed`
- `POST /jobs/{id}/start` (multipart field: `before_photo`)
- `POST /jobs/{id}/complete` (multipart field: `after_photo`, `otp`)

### Wallet
- `GET /wallet/summary`
- `GET /wallet/history`
- `POST /wallet/recharge`
  ```json
  { "amount": 500 }
  ```

### Dashboard
- `GET /dashboard/summary`

---

## 6) Notes

- Payments are mocked (recharge just adds balance + transaction).
- Uploads are stored in `public/uploads/*` so they are viewable in Admin.
- Seed includes 8 leads, 4 vendors, jobs, and wallet transactions.

---

## 7) Project Structure

- `public/` — landing page, admin panel, API router, uploads
- `public/api/index.php` — REST API router
- `config/` — DB, env loader, helpers
- `database/` — schema + seed SQL

---

If you want, I can also add:
- vendor-facing endpoint to fetch admin KYC notes
- pagination/search in admin tables
- role permissions for multiple admin users
